<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/config.php';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Clientes</title>
  <link rel="stylesheet" href="<?= h(url('/assets/styles.css')) ?>">
  <style>
    .field{display:flex;flex-direction:column;gap:4px;flex:1;min-width:160px}
    .field label{font-size:12px;color:#444}
    .actions{display:flex;gap:8px;flex-wrap:wrap}
  </style>
</head>
<body>
<?php include __DIR__ . '/../assets/nav.php'; ?>

<h2>Clientes</h2>
<div class="card">
  <input type="hidden" id="id" value="">
  <div class="row">
    <div class="field" style="flex:2;min-width:240px"><label>Nombre</label><input id="nombre" placeholder="Nombre del cliente"></div>
    <div class="field"><label>CI/RUC</label><input id="cedula_ruc" placeholder="CI o RUC"></div>
  </div>
  <div class="row">
    <div class="field"><label>Teléfono</label><input id="telefono" placeholder="099..."></div>
    <div class="field"><label>Correo</label><input id="correo" placeholder="correo@dominio.com"></div>
  </div>
  <div class="row">
    <div class="field" style="flex:2;min-width:280px"><label>Dirección</label><input id="direccion" placeholder="Dirección"></div>
  </div>
  <div class="row actions">
    <button class="btn" onclick="guardar()" id="btnGuardar">Guardar</button>
    <button class="btn secondary" onclick="limpiar()">Nuevo</button>
    <span class="muted" id="modo"></span>
  </div>
</div>

<h3>Buscar / Listar</h3>
<div class="row">
  <div class="field" style="flex:2;min-width:280px">
    <label>Buscar por nombre o CI/RUC</label>
    <input id="q" placeholder="Ej: Jose o 0102...">
  </div>
  <button class="btn secondary" onclick="buscar()" style="align-self:flex-end">Buscar</button>
  <button class="btn" onclick="listar()" style="align-self:flex-end">Ver últimos</button>
</div>

<table class="table" id="tabla">
  <thead><tr><th>ID</th><th>Nombre</th><th>CI/RUC</th><th>Teléfono</th><th>Correo</th><th></th></tr></thead>
  <tbody></tbody>
</table>

<script>
function limpiar(){
  document.getElementById('id').value='';
  ['nombre','cedula_ruc','direccion','correo','telefono'].forEach(x=>document.getElementById(x).value='');
  document.getElementById('modo').textContent='Modo: Nuevo';
  document.getElementById('btnGuardar').textContent='Guardar';
}
function cargar(c){
  document.getElementById('id').value=c.id;
  document.getElementById('nombre').value=c.nombre||'';
  document.getElementById('cedula_ruc').value=c.cedula_ruc||'';
  document.getElementById('direccion').value=c.direccion||'';
  document.getElementById('correo').value=c.correo||'';
  document.getElementById('telefono').value=c.telefono||'';
  document.getElementById('modo').textContent='Modo: Editando ID '+c.id;
  document.getElementById('btnGuardar').textContent='Actualizar';
  window.scrollTo({top:0,behavior:'smooth'});
}
function render(list){
  const tb=document.querySelector('#tabla tbody');
  tb.innerHTML='';
  list.forEach(c=>{
    const tr=document.createElement('tr');
    tr.innerHTML=`<td>${c.id}</td><td>${c.nombre||''}</td><td>${c.cedula_ruc||''}</td><td>${c.telefono||''}</td><td>${c.correo||''}</td>
                  <td><button class="btn secondary">Editar</button></td>`;
    tr.querySelector('button').onclick=()=>cargar(c);
    tb.appendChild(tr);
  });
}
async function guardar(){
  const id = document.getElementById('id').value;
  const body={
    id: id ? +id : undefined,
    nombre: document.getElementById('nombre').value.trim(),
    cedula_ruc: document.getElementById('cedula_ruc').value.trim(),
    direccion: document.getElementById('direccion').value.trim(),
    correo: document.getElementById('correo').value.trim(),
    telefono: document.getElementById('telefono').value.trim(),
  };
  const api = id ? '<?= h(url('/clientes/actualizar.php')) ?>' : '<?= h(url('/clientes/guardar.php')) ?>';
  const r=await fetch(api,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)});
  const d=await r.json();
  if(!d.ok){ alert(d.msg||'Error'); return; }
  alert(id ? 'Cliente actualizado' : ('Cliente guardado. ID: '+d.id));
  await listar();
  limpiar();
}
async function buscar(){
  const q=document.getElementById('q').value.trim();
  if(q.length<1){ alert('Escribe algo para buscar'); return; }
  const r=await fetch('<?= h(url('/clientes/buscar.php')) ?>?q='+encodeURIComponent(q));
  render(await r.json());
}
async function listar(){
  const r=await fetch('<?= h(url('/clientes/listar.php')) ?>');
  render(await r.json());
}
limpiar();
listar();
</script>
</body>
</html>
