<?php
/**
 * Configuración general
 * IMPORTANTE: Cambia usuario/clave y datos de negocio.
 */

// Ajusta esto a la ruta donde se instala el sistema (recomendado: /proformas)
const BASE_PATH = '/proformas';

// Activa para ver errores en pantalla (solo durante instalación)
const DEBUG = false;

const BUSINESS_NAME   = 'JPCOMPUEXTREME';
const BUSINESS_ADDR   = 'Tomas Ordoñez 9-18 y Simón Bolívar, Cuenca';
const BUSINESS_RUC    = '0503035024001';
const BUSINESS_PHONE1 = '0992570775';
const BUSINESS_PHONE2 = '0958829900';
const BUSINESS_EMAIL  = '';
const BUSINESS_WEBSITE= 'https://www.jpcompuextrem.com';

// IVA predeterminado
const DEFAULT_IVA_PCT = 15.0;

// WhatsApp
const WHATSAPP_COUNTRY_CODE = '593';

// Credenciales simples (recomendación: cambiar y luego migrar a hash)
const AUTH_USERNAME = 'admin';
const AUTH_PASSWORD = 'jpcompu918';

// Firma digital opcional (no se usa aún)
const SIGN_CERT_PATH = __DIR__ . '/../certs/certificado.p12';
const SIGN_CERT_PASS = '';
const SIGN_VISIBLE_IMG = __DIR__ . '/../assets/firma.png';
const SIGN_VISIBLE_NAME = 'Responsable';
const SIGN_VISIBLE_TITLE = 'JPCOMPUEXTREME';

// Helpers
function money($v): string { return '$' . number_format((float)$v, 2); }
function h($s): string { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function url(string $path): string {
  $base = rtrim(BASE_PATH, '/');
  if ($path === '' || $path[0] !== '/') $path = '/' . $path;
  return $base . $path;
}

if (DEBUG) {
  ini_set('display_errors', '1');
  ini_set('display_startup_errors', '1');
  error_reporting(E_ALL);
}
