<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/config.php';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Productos</title>
  <link rel="stylesheet" href="<?= h(url('/assets/styles.css')) ?>">
  <style>
    .field{display:flex;flex-direction:column;gap:4px;flex:1;min-width:160px}
    .field label{font-size:12px;color:#444}
    .actions{display:flex;gap:8px;flex-wrap:wrap}
  </style>
</head>
<body>
<?php include __DIR__ . '/../assets/nav.php'; ?>
<h2>Productos</h2>

<div class="card">
  <input type="hidden" id="id" value="">

  <div class="row">
    <div class="field"><label>Código</label><input id="codigo" placeholder="Ej: 01"></div>
    <div class="field" style="flex:2;min-width:240px"><label>Nombre</label><input id="nombre" placeholder="Nombre del producto"></div>
  </div>

  <div class="row">
    <div class="field"><label>Costo base</label><input id="costo_base" type="number" step="0.01" placeholder="0.00"></div>
    <div class="field"><label>Margen % (editable)</label><input id="margen_pct" type="number" step="0.01" value="35" placeholder="35"></div>
    <div class="field"><label>IVA %</label><input id="impuesto" type="number" step="0.01" value="<?= (float)DEFAULT_IVA_PCT ?>"></div>
  </div>

  <div class="row">
    <div class="field"><label>Stock</label><input id="stock" type="number" step="1" value="0"></div>
    <div class="field" style="flex:2;min-width:280px"><label>Descripción</label><input id="descripcion" placeholder="Detalle (opcional)"></div>
  </div>

  <div class="row actions">
    <button class="btn" onclick="guardar()" id="btnGuardar">Guardar</button>
    <button class="btn secondary" onclick="limpiar()">Nuevo</button>
    <span class="muted" id="modo"></span>
  </div>
</div>

<h3>Buscar / Listar</h3>
<div class="row">
  <div class="field" style="flex:2;min-width:280px">
    <label>Buscar por nombre o código</label>
    <input id="q" placeholder="Ej: cerra o 01">
  </div>
  <button class="btn secondary" onclick="buscar()" style="align-self:flex-end">Buscar</button>
  <button class="btn" onclick="listar()" style="align-self:flex-end">Ver últimos</button>
</div>

<table class="table" id="tabla">
  <thead><tr><th>ID</th><th>Código</th><th>Nombre</th><th class="right">Costo</th><th class="right">Margen%</th><th class="right">Precio</th><th class="right">IVA%</th><th></th></tr></thead>
  <tbody></tbody>
</table>

<script>
function limpiar(){
  document.getElementById('id').value='';
  document.getElementById('codigo').value='';
  document.getElementById('nombre').value='';
  document.getElementById('descripcion').value='';
  document.getElementById('costo_base').value='';
  document.getElementById('margen_pct').value='35';
  document.getElementById('impuesto').value='<?= (float)DEFAULT_IVA_PCT ?>';
  document.getElementById('stock').value='0';
  document.getElementById('modo').textContent='Modo: Nuevo';
  document.getElementById('btnGuardar').textContent='Guardar';
}

function cargar(p){
  document.getElementById('id').value=p.id;
  document.getElementById('codigo').value=p.codigo||'';
  document.getElementById('nombre').value=p.nombre||'';
  document.getElementById('descripcion').value=p.descripcion||'';
  document.getElementById('costo_base').value=(+p.costo_base||0).toFixed(2);
  document.getElementById('margen_pct').value=(+p.margen_pct||35).toFixed(2);
  document.getElementById('impuesto').value=(+p.impuesto||15).toFixed(2);
  document.getElementById('stock').value=(+p.stock||0);
  document.getElementById('modo').textContent='Modo: Editando ID '+p.id;
  document.getElementById('btnGuardar').textContent='Actualizar';
  window.scrollTo({top:0,behavior:'smooth'});
}

function render(list){
  const tb=document.querySelector('#tabla tbody');
  tb.innerHTML='';
  list.forEach(p=>{
    const tr=document.createElement('tr');
    tr.innerHTML=`<td>${p.id}</td><td>${p.codigo||''}</td><td>${p.nombre||''}</td>
      <td class="right">$${(+p.costo_base||0).toFixed(2)}</td>
      <td class="right">${(+p.margen_pct||0).toFixed(2)}</td>
      <td class="right">$${(+p.precio||0).toFixed(2)}</td>
      <td class="right">${(+p.impuesto||0).toFixed(2)}</td>
      <td><button class="btn secondary">Editar</button></td>`;
    tr.querySelector('button').onclick=()=>cargar(p);
    tb.appendChild(tr);
  });
}

async function guardar(){
  const id = document.getElementById('id').value;
  const body={
    id: id ? +id : undefined,
    codigo: document.getElementById('codigo').value.trim(),
    nombre: document.getElementById('nombre').value.trim(),
    descripcion: document.getElementById('descripcion').value.trim(),
    costo_base: +document.getElementById('costo_base').value || 0,
    margen_pct: +document.getElementById('margen_pct').value || 35,
    impuesto: +document.getElementById('impuesto').value || 15,
    stock: +document.getElementById('stock').value || 0,
  };
  const api = id ? '<?= h(url('/productos/actualizar.php')) ?>' : '<?= h(url('/productos/guardar.php')) ?>';
  const r=await fetch(api,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)});
  const d=await r.json();
  if(!d.ok){ alert(d.msg||'Error'); return; }
  alert(id ? 'Producto actualizado' : ('Producto guardado. ID: '+d.id+' | Precio: '+d.precio));
  await listar();
  limpiar();
}

async function buscar(){
  const q=document.getElementById('q').value.trim();
  if(q.length<1){ alert('Escribe algo para buscar'); return; }
  const r=await fetch('<?= h(url('/productos/buscar.php')) ?>?q='+encodeURIComponent(q));
  render(await r.json());
}

async function listar(){
  const r=await fetch('<?= h(url('/productos/listar.php')) ?>');
  render(await r.json());
}

limpiar();
listar();
</script>
</body>
</html>
