<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/config.php';

$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare('SELECT p.numero,p.pdf_url,c.telefono,c.nombre FROM proformas p JOIN clientes c ON c.id=p.cliente_id WHERE p.id=?');
$st->execute([$id]);
$row = $st->fetch();
if (!$row) exit('No encontrada');

$base = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https://' : 'http://') . ($_SERVER['HTTP_HOST'] ?? '');
$link = $row['pdf_url'] ? ($base . $row['pdf_url']) : ($base . url('/proformas/generar_pdf.php') . '?id=' . $id);

$tel = preg_replace('/\D+/', '', (string)($row['telefono'] ?? ''));
if ($tel && strpos($tel, WHATSAPP_COUNTRY_CODE) !== 0) $tel = WHATSAPP_COUNTRY_CODE . $tel;

$msg = 'Hola ' . ($row['nombre'] ?? '') . ', te envío la proforma ' . ($row['numero'] ?? '') . '. PDF: ' . $link;
header('Location: https://wa.me/' . $tel . '?text=' . urlencode($msg));
