<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/db.php';
header('Content-Type: application/json; charset=utf-8');

$in = json_decode(file_get_contents('php://input'), true) ?: $_POST;
$id = (int)($in['id'] ?? 0);
$nombre = trim($in['nombre'] ?? '');
if ($id<=0 || $nombre==='') {
  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>'ID y nombre requeridos']);
  exit;
}
$ced = trim($in['cedula_ruc'] ?? '');
$ced = ($ced==='') ? null : $ced;

try {
  $stmt = $pdo->prepare('UPDATE clientes SET nombre=?, cedula_ruc=?, direccion=?, correo=?, telefono=? WHERE id=?');
  $stmt->execute([$nombre,$ced,trim($in['direccion'] ?? ''),trim($in['correo'] ?? ''),trim($in['telefono'] ?? ''),$id]);
  echo json_encode(['ok'=>true]);
} catch (PDOException $e) {
  if ($e->getCode()==='23000') {
    http_response_code(409);
    echo json_encode(['ok'=>false,'msg'=>'CI/RUC duplicado.']);
  } else {
    http_response_code(500);
    echo json_encode(['ok'=>false,'msg'=>'Error al actualizar']);
  }
}
