<?php
require_once __DIR__ . '/lib/auth.php';
require_login();
require_once __DIR__ . '/lib/config.php';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Nueva Proforma</title>
  <link rel="stylesheet" href="<?= h(url('/assets/styles.css')) ?>">
  <style>
    .suggest{position:absolute;background:#fff;border:1px solid #ddd;display:none;width:100%;max-height:220px;overflow:auto;z-index:20;border-radius:8px;box-shadow:0 8px 24px rgba(0,0,0,.08)}
    .suggest div{padding:8px;cursor:pointer}
    .suggest div:hover{background:#f3f7ff}
    .field{display:flex;flex-direction:column;gap:4px}
    .field label{font-size:12px;color:#444}
    .mini{font-size:12px;color:#666}
  </style>
</head>
<body>
  <?php include __DIR__ . '/assets/nav.php'; ?>

  <h2>Crear Proforma</h2>
  <p class="muted">IVA predeterminado <?= (float)DEFAULT_IVA_PCT ?>% (editable). Puedes ajustar <b>margen</b> y <b>costo</b> por ítem para calcular el P.Unit.</p>

  <div class="row">
    <div class="field" style="position:relative;flex:2;min-width:280px">
      <label>Cliente (buscar)</label>
      <input id="cliente_buscar" placeholder="Nombre o CI/RUC" autocomplete="off">
      <div id="cliente_suggest" class="suggest"></div>
    </div>
    <div class="field" style="flex:1;min-width:160px">
      <label>ID Cliente</label>
      <input id="cliente_id" type="number" placeholder="Ej: 1">
    </div>
  </div>

  <div class="row">
    <div class="field" style="flex:1;min-width:160px">
      <label>Fecha</label>
      <input id="fecha" type="date">
    </div>
    <div class="field" style="flex:1;min-width:160px">
      <label>Validez (días)</label>
      <input id="validez" type="number" value="7" placeholder="7">
    </div>
  </div>

  <div class="row">
    <div class="field" style="flex:1;min-width:220px">
      <label>IVA predeterminado</label>
      <select id="iva_default">
        <option value="0">0%</option>
        <option value="12">12%</option>
        <option value="15" selected>15%</option>
      </select>
      <div class="mini">Se aplica al crear nuevos ítems (puedes cambiarlo por línea).</div>
    </div>
  </div>

  <table class="table" id="items">
    <thead>
      <tr>
        <th style="width:32%">Producto / Descripción (buscar)</th>
        <th style="width:10%">Código</th>
        <th class="right" style="width:10%">Cant</th>
        <th class="right" style="width:12%">Costo</th>
        <th class="right" style="width:10%">Margen %</th>
        <th class="right" style="width:12%">P.Unit</th>
        <th class="right" style="width:8%">IVA%</th>
        <th style="width:6%"></th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>

  <div class="row no-print">
    <button class="btn" onclick="agregarItem()">Agregar ítem</button>
  </div>

  <div class="row">
    <div class="field" style="max-width:220px">
      <label>Descuento</label>
      <input id="descuento" type="number" step="0.01" placeholder="0.00">
    </div>
  </div>

  <div class="row">
    <div class="field" style="flex:1">
      <label>Notas</label>
      <textarea id="notas" placeholder="Notas"></textarea>
    </div>
  </div>

  <div class="row no-print">
    <button class="btn" onclick="guardar()">Guardar proforma</button>
  </div>

<script>
document.getElementById('fecha').value = new Date().toISOString().slice(0,10);
function getIvaDefault(){ const v=parseFloat(document.getElementById('iva_default').value); return isNaN(v)?15:v; }
function calcPrecio(costo, margen){
  costo = parseFloat(costo||0); margen = parseFloat(margen||0);
  if(isNaN(costo)) costo=0; if(isNaN(margen)) margen=0;
  return Math.round((costo*(1+margen/100))*100)/100;
}

function agregarItem(desc='', cod='', cant=1, costo=0, margen=35, pu=0, iva=null){
  if(iva===null) iva=getIvaDefault();
  const tr=document.createElement('tr');
  const sugId = 'ps_' + Math.random().toString(16).slice(2);
  tr.innerHTML=`
    <td><input class="desc" placeholder="Buscar por nombre" value="${desc}" autocomplete="off"></td>
    <td style="position:relative">
      <input class="cod" placeholder="Código o nombre" value="${cod}" autocomplete="off">
      <div id="${sugId}" class="suggest"></div>
    </td>
    <td><input class="cant" type="number" step="0.01" value="${cant}"></td>
    <td><input class="costo" type="number" step="0.01" value="${costo}"></td>
    <td><input class="margen" type="number" step="0.01" value="${margen}"></td>
    <td><input class="pu" type="number" step="0.01" value="${pu}"></td>
    <td><input class="iva" type="number" step="0.01" value="${iva}"></td>
    <td><button class="btn secondary" onclick="this.closest('tr').remove()">✖</button></td>
  `;
  tr.querySelector('.cod').dataset.sug = sugId;
  document.querySelector('#items tbody').appendChild(tr);
}

agregarItem('', '', 1, 0, 35, 0, getIvaDefault());

// CLIENTES
const cs=document.getElementById('cliente_suggest');
document.getElementById('cliente_buscar').addEventListener('input', async e=>{
  const q=e.target.value.trim();
  if(q.length<2){ cs.style.display='none'; return; }
  const r=await fetch('<?= h(url('/clientes/buscar.php')) ?>?q='+encodeURIComponent(q));
  const list=await r.json();
  cs.innerHTML='';
  list.forEach(c=>{
    const d=document.createElement('div');
    d.textContent=`${c.nombre} — ${(c.cedula_ruc||'')}`;
    d.onclick=()=>{ document.getElementById('cliente_id').value=c.id; e.target.value=c.nombre; cs.style.display='none'; };
    cs.appendChild(d);
  });
  cs.style.display = list.length ? 'block' : 'none';
});

// PRODUCTOS
async function buscarProductos(q){
  const r=await fetch('<?= h(url('/productos/buscar.php')) ?>?q='+encodeURIComponent(q));
  return await r.json();
}
function cerrarSuggestProductos(){ document.querySelectorAll('#items .suggest').forEach(d=>d.style.display='none'); }

async function onInputProducto(ev){
  const input = ev.target;
  const esCod  = input.classList.contains('cod');
  const esDesc = input.classList.contains('desc');
  if(!esCod && !esDesc) return;

  const q = input.value.trim();
  const tr = input.closest('tr');
  const codInput = tr.querySelector('.cod');
  const sug = document.getElementById(codInput.dataset.sug);
  if(!sug) return;

  if(q.length < 2){ sug.style.display='none'; sug.innerHTML=''; return; }

  const list = await buscarProductos(q);
  sug.innerHTML='';
  list.slice(0, 15).forEach(p=>{
    const d=document.createElement('div');
    const codigo = p.codigo ? `(${p.codigo})` : '';
    d.textContent = `${p.nombre||''} ${codigo} — $${(+p.precio||0).toFixed(2)}`;
    d.onclick = ()=>{
      tr.querySelector('.desc').value = p.nombre || '';
      codInput.value = p.codigo || (p.nombre || '');
      if(p.costo_base!==undefined) tr.querySelector('.costo').value = (+p.costo_base||0).toFixed(2);
      if(p.margen_pct!==undefined) tr.querySelector('.margen').value = (+p.margen_pct||35).toFixed(2);
      const precioCalc = calcPrecio(tr.querySelector('.costo').value, tr.querySelector('.margen').value);
      tr.querySelector('.pu').value = (precioCalc>0 ? precioCalc : (+p.precio||0)).toFixed(2);
      tr.querySelector('.iva').value = (+p.impuesto||getIvaDefault()).toFixed(2);
      sug.style.display='none';
    };
    sug.appendChild(d);
  });
  sug.style.display = list.length ? 'block' : 'none';
}

document.addEventListener('input', onInputProducto);

document.addEventListener('input', (ev)=>{
  const input = ev.target;
  if(!input.classList.contains('costo') && !input.classList.contains('margen')) return;
  const tr=input.closest('tr');
  const p=calcPrecio(tr.querySelector('.costo').value, tr.querySelector('.margen').value);
  tr.querySelector('.pu').value = (p||0).toFixed(2);
});

document.addEventListener('click', (ev)=>{
  if(!ev.target.closest('.suggest') && !ev.target.classList.contains('cod') && !ev.target.classList.contains('desc')) cerrarSuggestProductos();
  if(!cs.contains(ev.target) && ev.target.id!=='cliente_buscar') cs.style.display='none';
});

async function guardar(){
  const items=[...document.querySelectorAll('#items tbody tr')].map(tr=>({
    descripcion: tr.querySelector('.desc').value.trim(),
    cantidad: +tr.querySelector('.cant').value,
    precio_unit: +tr.querySelector('.pu').value,
    impuesto_pct: +tr.querySelector('.iva').value
  })).filter(x=>x.descripcion);

  const body={
    cliente_id:+document.getElementById('cliente_id').value,
    fecha:document.getElementById('fecha').value,
    validez_dias:+document.getElementById('validez').value||7,
    descuento:+document.getElementById('descuento').value||0,
    notas:document.getElementById('notas').value,
    items
  };

  const r=await fetch('<?= h(url('/proformas/crear.php')) ?>',{
    method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)
  });
  const data=await r.json();
  if(!data.ok){ alert(data.msg||'Error'); return; }
  location.href='<?= h(url('/proformas/ver.php')) ?>?id='+data.proforma_id;
}
</script>
</body>
</html>
