<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/db.php';
header('Content-Type: application/json; charset=utf-8');

$in = json_decode(file_get_contents('php://input'), true) ?: $_POST;
$cliente_id = (int)($in['cliente_id'] ?? 0);
$fecha = $in['fecha'] ?? date('Y-m-d');
$validez = (int)($in['validez_dias'] ?? 7);
$descuento = (float)($in['descuento'] ?? 0);
$notas = (string)($in['notas'] ?? '');
$items = $in['items'] ?? [];

if ($cliente_id <= 0 || !$items) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>'Datos incompletos']);
  exit;
}

$subtotal = 0;
$imp_total = 0;
foreach ($items as &$it) {
  $cant = (float)($it['cantidad'] ?? 0);
  $pu   = (float)($it['precio_unit'] ?? 0);
  $imp  = (float)($it['impuesto_pct'] ?? 0);
  $linea = $cant * $pu;
  $imp_m = $linea * $imp / 100;
  $it['total_linea'] = round($linea + $imp_m, 2);
  $subtotal += $linea;
  $imp_total += $imp_m;
}
$total = $subtotal - $descuento + $imp_total;

$pdo->beginTransaction();
try {
  $y = date('Y');
  $corr = (int)$pdo->query('SELECT COUNT(*) c FROM proformas WHERE YEAR(created_at)=YEAR(CURDATE())')->fetch()['c'] + 1;
  $numero = sprintf('PF-%s-%04d', $y, $corr);

  $st = $pdo->prepare('INSERT INTO proformas (numero,cliente_id,fecha,validez_dias,subtotal,descuento,impuesto_total,total,notas) VALUES (?,?,?,?,?,?,?,?,?)');
  $st->execute([$numero, $cliente_id, $fecha, $validez, $subtotal, $descuento, $imp_total, $total, $notas]);
  $pf_id = $pdo->lastInsertId();

  $sti = $pdo->prepare('INSERT INTO proforma_items (proforma_id,descripcion,cantidad,precio_unit,impuesto_pct,total_linea) VALUES (?,?,?,?,?,?)');
  foreach ($items as $it) {
    $sti->execute([$pf_id, (string)$it['descripcion'], (float)$it['cantidad'], (float)$it['precio_unit'], (float)$it['impuesto_pct'], (float)$it['total_linea']]);
  }

  $pdo->commit();
  echo json_encode(['ok'=>true,'proforma_id'=>$pf_id,'numero'=>$numero]);
} catch (Exception $e) {
  $pdo->rollBack();
  http_response_code(500);
  echo json_encode(['ok'=>false,'msg'=>DEBUG ? $e->getMessage() : 'Error']);
}
