<?php
require_once __DIR__ . '/lib/auth.php';
require_login();
require_once __DIR__ . '/lib/config.php';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Nueva Proforma</title>
  <link rel="stylesheet" href="<?= h(url('/assets/styles.css')) ?>">
</head>
<body>
  <?php include __DIR__ . '/assets/nav.php'; ?>

  <h2>Crear Proforma</h2>
  <p class="muted">IVA predeterminado <?= (float)DEFAULT_IVA_PCT ?>% (editable).</p>

  <div class="row">
    <div style="position:relative;flex:2;min-width:280px">
      <input id="cliente_buscar" placeholder="Buscar cliente (nombre o CI/RUC)" autocomplete="off">
      <div id="cliente_suggest" style="position:absolute; background:#fff; border:1px solid #ddd; display:none; width:100%; max-height:220px; overflow:auto; z-index:10"></div>
    </div>
    <input id="cliente_id" type="number" placeholder="ID Cliente" style="flex:1;min-width:160px">
  </div>

  <div class="row">
    <input id="fecha" type="date" style="flex:1;min-width:160px">
    <input id="validez" type="number" value="7" style="flex:1;min-width:160px" placeholder="Validez días">
  </div>

  <div class="row">
    <label style="flex:1;min-width:220px">IVA predeterminado
      <select id="iva_default">
        <option value="0">0%</option>
        <option value="12">12%</option>
        <option value="15" selected>15%</option>
      </select>
    </label>
  </div>

  <table class="table" id="items">
    <thead>
      <tr>
        <th>Descripción</th>
        <th>Código</th>
        <th class="right">Cant</th>
        <th class="right">P.Unit</th>
        <th class="right">IVA%</th>
        <th></th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>

  <div class="row no-print">
    <button class="btn" onclick="agregarItem()">Agregar ítem</button>
  </div>

  <div class="row">
    <input id="descuento" type="number" step="0.01" placeholder="Descuento" style="max-width:220px">
  </div>
  <div class="row">
    <textarea id="notas" placeholder="Notas"></textarea>
  </div>

  <div class="row no-print">
    <button class="btn" onclick="guardar()">Guardar proforma</button>
  </div>

<script>
document.getElementById('fecha').value = new Date().toISOString().slice(0,10);
function getIvaDefault(){ const v=parseFloat(document.getElementById('iva_default').value); return isNaN(v)?15:v; }
function agregarItem(desc='', cod='', cant=1, pu=0, iva=null){
  if(iva===null) iva=getIvaDefault();
  const tr=document.createElement('tr');
  tr.innerHTML=`<td><input class="desc" value="${desc}"></td>
    <td><input class="cod" value="${cod}"></td>
    <td><input class="cant" type="number" step="0.01" value="${cant}"></td>
    <td><input class="pu" type="number" step="0.01" value="${pu}"></td>
    <td><input class="iva" type="number" step="0.01" value="${iva}"></td>
    <td><button class="btn secondary" onclick="this.closest('tr').remove()">✖</button></td>`;
  document.querySelector('#items tbody').appendChild(tr);
}
agregarItem();

// Autocomplete clientes
const cs=document.getElementById('cliente_suggest');
document.getElementById('cliente_buscar').addEventListener('input', async e=>{
  const q=e.target.value.trim();
  if(q.length<2){ cs.style.display='none'; return; }
  const r=await fetch('<?= h(url('/clientes/buscar.php')) ?>?q='+encodeURIComponent(q));
  const list=await r.json();
  cs.innerHTML='';
  list.forEach(c=>{
    const d=document.createElement('div');
    d.style.padding='6px'; d.style.cursor='pointer';
    d.textContent=`${c.nombre} — ${(c.cedula_ruc||'')}`;
    d.onclick=()=>{ document.getElementById('cliente_id').value=c.id; e.target.value=c.nombre; cs.style.display='none'; };
    cs.appendChild(d);
  });
  cs.style.display='block';
});

document.addEventListener('click', (ev)=>{
  if(!cs.contains(ev.target) && ev.target.id!=='cliente_buscar') cs.style.display='none';
});

async function guardar(){
  const rows=[...document.querySelectorAll('#items tbody tr')];
  const items=rows.map(tr=>({
      descripcion: tr.querySelector('.desc').value.trim(),
      codigo: tr.querySelector('.cod').value.trim(),
      cantidad: +tr.querySelector('.cant').value,
      precio_unit: +tr.querySelector('.pu').value,
      impuesto_pct: +tr.querySelector('.iva').value
  })).filter(x=>x.descripcion);

  const body={
    cliente_id: +document.getElementById('cliente_id').value,
    fecha: document.getElementById('fecha').value,
    validez_dias: +document.getElementById('validez').value || 7,
    descuento: +document.getElementById('descuento').value || 0,
    notas: document.getElementById('notas').value,
    items
  };

  const r=await fetch('<?= h(url('/proformas/crear.php')) ?>',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)});
  const data=await r.json();
  if(!data.ok){ alert(data.msg||'Error'); return; }
  location.href='<?= h(url('/proformas/ver.php')) ?>?id='+data.proforma_id;
}
</script>

</body>
</html>
