<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/config.php';

$st = $pdo->query('SELECT p.id,p.numero,p.fecha,p.total,c.nombre cliente FROM proformas p JOIN clientes c ON c.id=p.cliente_id ORDER BY p.id DESC LIMIT 200');
$rows = $st->fetchAll();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Proformas</title>
  <link rel="stylesheet" href="<?= h(url('/assets/styles.css')) ?>">
</head>
<body>
<?php include __DIR__ . '/../assets/nav.php'; ?>
<h2>Proformas guardadas</h2>
<table class="table">
  <thead><tr><th>ID</th><th>Número</th><th>Cliente</th><th>Fecha</th><th class="right">Total</th><th></th></tr></thead>
  <tbody>
  <?php foreach($rows as $r): ?>
    <tr>
      <td><?= (int)$r['id'] ?></td>
      <td><?= h($r['numero']) ?></td>
      <td><?= h($r['cliente']) ?></td>
      <td><?= h($r['fecha']) ?></td>
      <td class="right"><?= money($r['total']) ?></td>
      <td><a class="btn secondary" href="<?= h(url('/proformas/ver.php')) ?>?id=<?= (int)$r['id'] ?>">Ver</a></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</body>
</html>
