<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/db.php';
header('Content-Type: application/json; charset=utf-8');

$in = json_decode(file_get_contents('php://input'), true) ?: $_POST;
$nombre = trim($in['nombre'] ?? '');
if ($nombre === '') {
  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>'Nombre requerido']);
  exit;
}

$codigo = trim($in['codigo'] ?? '');
$codigo = ($codigo === '') ? null : $codigo; // permite múltiples NULL sin chocar con UNIQUE

$costo = (float)($in['costo_base'] ?? 0);
$margen = (float)($in['margen_pct'] ?? 35);
$precio = round($costo * (1 + $margen/100), 2);

try {
  $stmt = $pdo->prepare('INSERT INTO productos (codigo,nombre,descripcion,costo_base,margen_pct,precio,impuesto,stock) VALUES (?,?,?,?,?,?,?,?)');
  $stmt->execute([
    $codigo,
    $nombre,
    trim($in['descripcion'] ?? ''),
    $costo,
    $margen,
    $precio,
    (float)($in['impuesto'] ?? 15),
    (int)($in['stock'] ?? 0),
  ]);
  echo json_encode(['ok'=>true,'id'=>$pdo->lastInsertId(),'precio'=>$precio]);
} catch (PDOException $e) {
  if ($e->getCode() === '23000') {
    http_response_code(409);
    echo json_encode(['ok'=>false,'msg'=>'Código duplicado. Usa otro código o edita el producto existente.']);
  } else {
    http_response_code(500);
    echo json_encode(['ok'=>false,'msg'=>'Error al guardar']);
  }
}
