<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/config.php';

// Dompdf
require_once __DIR__ . '/../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { http_response_code(400); exit('ID inválido'); }

$pf = $pdo->prepare('SELECT p.*, c.nombre cliente_nombre, c.cedula_ruc, c.direccion, c.correo, c.telefono FROM proformas p JOIN clientes c ON c.id=p.cliente_id WHERE p.id=?');
$pf->execute([$id]);
$p = $pf->fetch();
if (!$p) { http_response_code(404); exit('No encontrada'); }

$it = $pdo->prepare('SELECT * FROM proforma_items WHERE proforma_id=?');
$it->execute([$id]);
$items = $it->fetchAll();

// URL pública del PDF
$base = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https://' : 'http://') . ($_SERVER['HTTP_HOST'] ?? '');
$fname = 'proforma_' . $id . '.pdf';
$pdf_url = url('/storage/pdf/' . $fname); // relativa
$pdf_public_url = $base . $pdf_url;

// Cargar logo (local) en base64 para que Dompdf lo renderice siempre
$logo_path = __DIR__ . '/../assets/logo.png';
$logo_data = '';
if (file_exists($logo_path)) {
  $mime = function_exists('mime_content_type') ? mime_content_type($logo_path) : 'image/png';
  $logo_data = 'data:' . $mime . ';base64,' . base64_encode(file_get_contents($logo_path));
}

// Intentar generar QR (sin librería) usando un servicio externo y embebiendo en base64.
// Si tu hosting bloquea conexiones salientes, el PDF saldrá sin QR.
function fetch_qr_base64(string $data, int $size = 220): string {
  $url = 'https://api.qrserver.com/v1/create-qr-code/?size=' . $size . 'x' . $size . '&data=' . urlencode($data);
  $bin = false;

  // Preferir cURL si existe
  if (function_exists('curl_init')) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 8);
    $bin = curl_exec($ch);
    curl_close($ch);
  } elseif (ini_get('allow_url_fopen')) {
    $ctx = stream_context_create(['http' => ['timeout' => 8]]);
    $bin = @file_get_contents($url, false, $ctx);
  }

  if (!$bin) return '';
  return 'data:image/png;base64,' . base64_encode($bin);
}

$qr_text = 'Fecha: ' . ($p['fecha'] ?? '') . "\n" . 'Proforma: ' . ($p['numero'] ?? '') . "\n" . $pdf_public_url;
$qr_data = fetch_qr_base64($qr_text, 220);

$web_show = preg_replace('/^https?:\\/\\//', '', (string)BUSINESS_WEBSITE);
$phones_show = trim((string)BUSINESS_PHONE1) . (BUSINESS_PHONE2 ? ' / ' . trim((string)BUSINESS_PHONE2) : '');

// Totales (ya están guardados en la tabla proformas)
$subtotal = (float)($p['subtotal'] ?? 0);
$descuento = (float)($p['descuento'] ?? 0);
$iva_total = (float)($p['impuesto_total'] ?? 0);
$total = (float)($p['total'] ?? 0);

// HTML del PDF (todo con tablas para que se vea profesional)
ob_start();
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<style>
  @page { margin: 22px 22px 22px 22px; }
  body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 12px; color: #111; }

  .header { width: 100%; border-collapse: collapse; }
  .header td { vertical-align: middle; }
  .logo { width: 120px; }
  .empresa { font-size: 16px; font-weight: 700; }
  .muted { color: #444; font-size: 11px; }

  .box { width: 100%; border-collapse: collapse; margin-top: 10px; }
  .box td { border: 1px solid #000; padding: 6px; }

  .items { width: 100%; border-collapse: collapse; margin-top: 10px; }
  .items th, .items td { border: 1px solid #000; padding: 6px; }
  .items th { background: #f2f2f2; }

  .right { text-align: right; }
  .center { text-align: center; }

  .totals { width: 45%; border-collapse: collapse; margin-top: 10px; float: right; }
  .totals td { border: 1px solid #000; padding: 6px; }
  .totals .label { background: #f2f2f2; font-weight: 700; }

  .clearfix { clear: both; }
  .section-title { margin-top: 14px; font-weight: 700; font-size: 12px; }
  ol { margin: 6px 0 0 18px; padding: 0; }
  li { margin-bottom: 4px; }

  .qrwrap { margin-top: 12px; text-align: center; }
  .firma { margin-top: 6px; font-size: 12px; }
  .small { font-size: 10.5px; color: #222; }
</style>
</head>
<body>

<!-- Encabezado -->
<table class="header">
  <tr>
    <td style="width: 28%;">
      <?php if ($logo_data): ?>
        <img class="logo" src="<?= $logo_data ?>">
      <?php endif; ?>
    </td>
    <td style="width: 72%; text-align: right;">
      <div class="empresa"><?= h(BUSINESS_NAME) ?></div>
      <div class="muted"><?= h(BUSINESS_ADDR) ?></div>
      <div class="muted">RUC: <?= h(BUSINESS_RUC) ?></div>
      <div class="muted">Tel: <?= h($phones_show) ?></div>
      <div class="muted">Web: <?= h($web_show) ?></div>
    </td>
  </tr>
</table>

<!-- Datos proforma y cliente -->
<table class="box">
  <tr>
    <td style="width: 50%;"><b>Proforma N°:</b> <?= h($p['numero']) ?></td>
    <td style="width: 50%;"><b>Fecha:</b> <?= h($p['fecha']) ?> &nbsp;&nbsp; <b>Validez:</b> <?= (int)$p['validez_dias'] ?> días</td>
  </tr>
  <tr>
    <td><b>Cliente:</b> <?= h($p['cliente_nombre']) ?></td>
    <td><b>CI/RUC:</b> <?= h($p['cedula_ruc'] ?? '') ?></td>
  </tr>
  <tr>
    <td><b>Teléfono:</b> <?= h($p['telefono'] ?? '') ?></td>
    <td><b>Correo:</b> <?= h($p['correo'] ?? '') ?></td>
  </tr>
  <tr>
    <td colspan="2"><b>Dirección:</b> <?= h($p['direccion'] ?? '') ?></td>
  </tr>
</table>

<!-- Detalle de ítems -->
<table class="items">
  <thead>
    <tr>
      <th class="center" style="width:10%;">Cant.</th>
      <th style="width:55%;">Descripción</th>
      <th class="right" style="width:15%;">P. Unit</th>
      <th class="center" style="width:10%;">IVA%</th>
      <th class="right" style="width:10%;">Total</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($items as $r): ?>
      <tr>
        <td class="center"><?= number_format((float)$r['cantidad'], 2) ?></td>
        <td><?= h($r['descripcion']) ?></td>
        <td class="right"><?= money((float)$r['precio_unit']) ?></td>
        <td class="center"><?= number_format((float)$r['impuesto_pct'], 2) ?></td>
        <td class="right"><?= money((float)$r['total_linea']) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<!-- Totales -->
<table class="totals">
  <tr><td class="label">Subtotal</td><td class="right"><?= money($subtotal) ?></td></tr>
  <tr><td class="label">Descuento</td><td class="right"><?= money($descuento) ?></td></tr>
  <tr><td class="label">IVA</td><td class="right"><?= money($iva_total) ?></td></tr>
  <tr><td class="label">TOTAL</td><td class="right"><b><?= money($total) ?></b></td></tr>
</table>
<div class="clearfix"></div>

<?php if (!empty($p['notas'])): ?>
  <div class="section-title">Notas</div>
  <div class="small"><?= nl2br(h($p['notas'])) ?></div>
<?php endif; ?>

<!-- Condiciones y garantías -->
<div class="section-title">Condiciones y garantías</div>
<ol>
  <li><b>Plazo de pago:</b> El pago será el 50% al inicio y el 50% restante al entregar los productos o servicios una vez aceptada la proforma.</li>
  <li><b>Forma de pago:</b> Se puede realizar mediante transferencia bancaria o en efectivo.</li>
  <li><b>Garantía de calidad:</b> Los productos están garantizados por un período de 12 meses contra defectos de fabricación.</li>
  <li><b>Garantía de funcionamiento:</b> Los productos están garantizados por un período de 12 meses contra fallos de funcionamiento.</li>
  <li><b>Condiciones de garantía:</b> La garantía se aplica solo si el producto se utiliza de acuerdo con las instrucciones del fabricante y se mantiene en buen estado, no nos responsabilizamos por daños causados por variaciones de voltaje.</li>
</ol>

<!-- QR + firma -->
<div class="qrwrap">
  <?php if ($qr_data): ?>
    <img src="<?= $qr_data ?>" style="width: 150px; height: 150px;">
    <div class="small" style="margin-top:4px;"><?= h($pdf_public_url) ?></div>
  <?php else: ?>
    <div class="small">(QR no disponible: el hosting bloquea conexiones salientes o no hay cURL/allow_url_fopen)</div>
    <div class="small"><?= h($pdf_public_url) ?></div>
  <?php endif; ?>

  <div class="firma"><b>Ing. José Patiño</b> <br> Gerente</div>
</div>

</body>
</html>
<?php
$html = ob_get_clean();

$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('defaultFont', 'DejaVu Sans');

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$pdf = $dompdf->output();

$dir = __DIR__ . '/../storage/pdf';
if (!is_dir($dir)) { @mkdir($dir, 0755, true); }
$path = $dir . '/' . $fname;
file_put_contents($path, $pdf);

// Guardar URL en DB
$up = $pdo->prepare('UPDATE proformas SET pdf_url=? WHERE id=?');
$up->execute([$pdf_url, $id]);

header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="' . $fname . '"');
echo $pdf;
