<?php
require_once __DIR__ . '/../lib/auth.php';
require_login();
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/config.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) exit('ID inválido');

$pf = $pdo->prepare('SELECT p.*, c.nombre cliente_nombre, c.cedula_ruc, c.direccion, c.correo, c.telefono FROM proformas p JOIN clientes c ON c.id=p.cliente_id WHERE p.id=?');
$pf->execute([$id]);
$p = $pf->fetch();
if (!$p) exit('No encontrada');

$it = $pdo->prepare('SELECT * FROM proforma_items WHERE proforma_id=?');
$it->execute([$id]);
$items = $it->fetchAll();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Proforma <?= h($p['numero']) ?></title>
  <link rel="stylesheet" href="<?= h(url('/assets/styles.css')) ?>">
</head>
<body>
<?php include __DIR__ . '/../assets/nav.php'; ?>

<div class="row" style="justify-content:space-between;align-items:flex-start">
  <div>
    <h2 style="margin:0">PROFORMA <span class="badge"><?= h($p['numero']) ?></span></h2>
    <div class="muted">Fecha: <?= h($p['fecha']) ?> · Validez: <?= (int)$p['validez_dias'] ?> días</div>
  </div>
  <div class="right">
    <div><b><?= h(BUSINESS_NAME) ?></b></div>
    <div><?= h(BUSINESS_ADDR) ?></div>
    <div>RUC: <?= h(BUSINESS_RUC) ?></div>
    <div>WhatsApp: <?= h(BUSINESS_PHONE1) ?><?= BUSINESS_PHONE2 ? ' / ' . h(BUSINESS_PHONE2) : '' ?></div>
    <div>Web: <?= h(preg_replace('/^https?:\/\//','', BUSINESS_WEBSITE)) ?></div>
  </div>
</div>

<hr>

<h3>Cliente</h3>
<div class="card">
  <div><b><?= h($p['cliente_nombre']) ?></b></div>
  <div class="muted">CI/RUC: <?= h($p['cedula_ruc'] ?? '') ?></div>
  <div class="muted">Dirección: <?= h($p['direccion'] ?? '') ?></div>
  <div class="muted">Teléfono: <?= h($p['telefono'] ?? '') ?> · Correo: <?= h($p['correo'] ?? '') ?></div>
</div>

<h3>Detalle</h3>
<table class="table">
  <thead>
    <tr><th>Descripción</th><th class="right">Cant</th><th class="right">P.Unit</th><th class="right">IVA%</th><th class="right">Total</th></tr>
  </thead>
  <tbody>
    <?php foreach($items as $r): ?>
      <tr>
        <td><?= h($r['descripcion']) ?></td>
        <td class="right"><?= number_format((float)$r['cantidad'], 2) ?></td>
        <td class="right"><?= money($r['precio_unit']) ?></td>
        <td class="right"><?= number_format((float)$r['impuesto_pct'], 2) ?></td>
        <td class="right"><?= money($r['total_linea']) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<div class="row" style="justify-content:flex-end">
  <div class="card" style="min-width:320px">
    <div class="row" style="justify-content:space-between"><span>Subtotal:</span><b><?= money($p['subtotal']) ?></b></div>
    <div class="row" style="justify-content:space-between"><span>Descuento:</span><b><?= money($p['descuento']) ?></b></div>
    <div class="row" style="justify-content:space-between"><span>IVA:</span><b><?= money($p['impuesto_total']) ?></b></div>
    <div class="row" style="justify-content:space-between"><span>Total:</span><b><?= money($p['total']) ?></b></div>
  </div>
</div>

<?php if(!empty($p['notas'])): ?>
  <h3>Notas</h3>
  <div class="card"><?= nl2br(h($p['notas'])) ?></div>
<?php endif; ?>

<div class="row no-print" style="gap:10px">
  <button class="btn secondary" onclick="window.print()">Imprimir</button>
  <a class="btn" href="<?= h(url('/proformas/generar_pdf.php')) ?>?id=<?= (int)$id ?>" target="_blank">Generar / Descargar PDF</a>
  <a class="btn" href="<?= h(url('/proformas/compartir_whatsapp.php')) ?>?id=<?= (int)$id ?>">Enviar por WhatsApp (link PDF)</a>
</div>

<p class="muted">Nota: WhatsApp enviará un enlace al PDF. Si el PDF aún no existe, el enlace lo generará al abrirlo.</p>

</body>
</html>
