CREATE TABLE IF NOT EXISTS clientes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nombre VARCHAR(150) NOT NULL,
  cedula_ruc VARCHAR(20) UNIQUE,
  direccion VARCHAR(250),
  correo VARCHAR(150),
  telefono VARCHAR(30),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS productos (
  id INT AUTO_INCREMENT PRIMARY KEY,
  codigo VARCHAR(50) UNIQUE,
  nombre VARCHAR(200) NOT NULL,
  descripcion TEXT,
  costo_base DECIMAL(10,2) NOT NULL DEFAULT 0,
  margen_pct DECIMAL(5,2) NOT NULL DEFAULT 35.00,
  precio DECIMAL(10,2) NOT NULL DEFAULT 0,
  impuesto DECIMAL(5,2) NOT NULL DEFAULT 15.00,
  stock INT DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS proformas (
  id INT AUTO_INCREMENT PRIMARY KEY,
  numero VARCHAR(30) UNIQUE,
  cliente_id INT NOT NULL,
  fecha DATE NOT NULL,
  validez_dias INT DEFAULT 7,
  subtotal DECIMAL(10,2) NOT NULL DEFAULT 0,
  descuento DECIMAL(10,2) NOT NULL DEFAULT 0,
  impuesto_total DECIMAL(10,2) NOT NULL DEFAULT 0,
  total DECIMAL(10,2) NOT NULL DEFAULT 0,
  notas TEXT,
  pdf_url VARCHAR(300),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT fk_pf_cliente FOREIGN KEY (cliente_id) REFERENCES clientes(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS proforma_items (
  id INT AUTO_INCREMENT PRIMARY KEY,
  proforma_id INT NOT NULL,
  producto_id INT NULL,
  descripcion VARCHAR(255) NOT NULL,
  cantidad DECIMAL(10,2) NOT NULL,
  precio_unit DECIMAL(10,2) NOT NULL,
  impuesto_pct DECIMAL(5,2) NOT NULL,
  total_linea DECIMAL(10,2) NOT NULL,
  CONSTRAINT fk_pfi_pf FOREIGN KEY (proforma_id) REFERENCES proformas(id),
  CONSTRAINT fk_pfi_prod FOREIGN KEY (producto_id) REFERENCES productos(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
